<?php

/**
 * ARK Manager File
 *  
 * Contains the ARK Manager code 
 *
 * @author Robbie Hott
 * @license http://opensource.org/licenses/BSD-3-Clause BSD 3-Clause
 * @copyright 2015 the Rector and Visitors of the University of Virginia, and
 *            the Regents of the University of California
 */
namespace ark;

/**
 * ARK Manager
 *
 * This class manages ARK ids, including the assigning of real arks as well as the minting of temporary
 * arks for testing purposes.
 *
 * @author Robbie Hott
 */
class ArkManager {

    /**
     * @var \ark\database\DatabaseConnector The helper class object for database connections
     */
    private $db = null;

    /**
     * Constructor
     *
     * Sets up the ArkManager
     */
    public function __construct() {

    }

    /**
     * Mint Temporary Ark
     *
     * Mint arks used for testing purposes.  These are not "valid" arks but are randomly generated based on
     * a seed of the current timestamp.  They should not be used for production purposes and are not guaranteed
     * to resolve.
     *
     * @param integer $num optional The number of arks to generate. If more than one, this method will return an array
     * @return string|string[] A temporary ark or a list of temporary arks
     */
    public function mintTemporaryArk($num=1) {

    }

    /**
     * Mint Real Ark
     *
     * Mint a real, unique, permanent, resolvable ark.  Once an ark is minted using this method, it will never be reassigned. This
     * process is irreversible, so use with caution.  Because of this, only one may be requested at a time.
     *
     * @return string A new permanent arkID
     */
    public function mintArk() {

    }

}
