<?php
/**
 * Ark Manager Test File
 *
 * @author Robbie Hott
 * @license http://opensource.org/licenses/BSD-3-Clause BSD 3-Clause
 * @copyright 2015 the Rector and Visitors of the University of Virginia, and
 *            the Regents of the University of California
 */
namespace test\ark;
use \ark\ArkManager;

/**
 * Ark Manager Test Class
 */
class ArkManagerTest extends \PHPUnit_Framework_TestCase {

    public $am = null;

    public function setUp() {
        $this->am = new ArkManager();
    }

    public function testBadTemporaryArkCount() {
        $this->assertNull($this->am->mintTemporaryArk(null)); 
        $this->assertNull($this->am->mintTemporaryArk(-1)); 
        $this->assertNull($this->am->mintTemporaryArk('one')); 
        $this->assertNull($this->am->mintTemporaryArk(0)); 
    }

    public function testOneTemporaryArk() {
        $ark = $this->am->mintTemporaryArk();

        $this->assertNotNull($ark, "Minting should have returned one ark");
        $this->assertFalse(is_array($ark), "One Ark should be given as a string");
        
        $ark = $this->am->mintTemporaryArk(1);

        $this->assertNotNull($ark, "Minting should have returned one ark");
        $this->assertFalse(is_array($ark), "One Ark should be given as a string");
    }

    public function testManyTemporaryArk() {
        $arks = $this->am->mintTemporaryArk(5);
        $this->assertNotNull($arks, "Minting should have returned array of ark");
        $this->assertTrue(is_array($arks), "Arks should be given as an array of strings");
        $this->assertEquals(5, count($arks), "We asked for 5, but were given " . count($arks));
        
        $arks = $this->am->mintTemporaryArk(25);
        $this->assertNotNull($arks, "Minting should have returned array of ark");
        $this->assertTrue(is_array($arks), "Arks should be given as an array of strings");
        $this->assertEquals(25, count($arks), "We asked for 25, but were given " . count($arks));
    }

    public function testTemporaryArkRandomness() {
        $arks = $this->am->mintTemporaryArk(25000);
        $this->assertNotNull($arks, "Minting should have returned array of ark");
        $this->assertTrue(is_array($arks), "Arks should be given as an array of strings");
        $this->assertEquals(25000, count($arks), "We asked for 25000, but were given " . count($arks));

        for ($i = 0; $i < 1000; $i++) {
            $ark = $this->am->mintTemporaryArk();
            $this->assertNotContains($ark, $arks, "Ark was found to repeat: " . $ark);
        }
    }
}
