<?php
/**
 * Full Install Script 
 *
 * @author Robbie Hott
 * @license http://opensource.org/licenses/BSD-3-Clause BSD 3-Clause
 * @copyright 2015 the Rector and Visitors of the University of Virginia, and
 * the Regents of the University of California
 */

// Move to the directory containing this script
chdir(dirname(__FILE__));

// Autoload the SNAC server codebase
include("../vendor/autoload.php");

use \ark\Config as Config;

$automate = false;
if ($argc == 2 && $argv[1] == "automate")
    $automate = true;

$host = Config::$DATABASE["host"];
$port = Config::$DATABASE["port"];
$database = Config::$DATABASE["database"];
$password = Config::$DATABASE["password"];
$user = Config::$DATABASE["user"];

// Try to create the database

echo "Would you like to try creating the PostgreSQL database?\n  ('yes' or 'no'): ";
$response = "no";
if (!$automate)
    $response = trim(fgets(STDIN));
else
    echo "no\n";

if ($response == "yes") {
    echo "  Trying to create the database.  This script requires SUDO\n".
        "  privileges to switch to the postgres user to create the \n".
        "  database.  Enter the password for SUDO next:\n";
    
    $retval = 0;
    // Run a system shell command, that sudos bash, then su's to postgres user,
    // then creates the user and database from the Config class.
    system("
sudo bash -c \"
su postgres -c '
createuser -D -l -R -P $user <<EOF
$password
$password
EOF
psql <<EOF
create database $database;
grant create,connect on database $database to $user;
EOF'
    \"\n", $retval);
    
    if ($retval != 0) {
        echo "  There was a problem creating the database.  Use the\n".
            "  following commands to create the database:\n\n".
            "  As the postgres user, in a shell:\n".
            "    postgres@server$ createuser -D -l -R -P $user\n\n".
            "  In the postgres shell as the root pgsql user:\n".
            "    psql> create database $database;\n".
            "    psql> grant create,connect on database $database to $user;\n\n";
    }
} else {
    echo "  Not creating the database.\n\n";
}


// Try to connect to the database
echo "Attempting to make a database connection.\n\n";

$dbHandle = pg_connect("host=$host port=$port dbname=$database user=$user password=$password");
// If the connection does not throw an exception, but the connector is false, then throw.
if ($dbHandle === false) {
    die("ERR: Unable to connect to database.\n");
}


echo "Would you like to load the schema into the database?\n  ('yes' or 'no'): ";
$response = "no";
if (!$automate)
    $response = trim(fgets(STDIN));
else
    echo "no\n";

if ($response == "yes") {
    echo "  Running the SQL initialization script\n";
    $res = pg_query($dbHandle, file_get_contents("sql_files/schema.sql"));

    if (!$res) {
        $error = pg_last_error($dbHandle);
        echo "  ERR: Unable to run script due to the following error:\n";
        echo $error."\n";
        die();
    }
    echo "  Successfully loaded the schema.\n";

} else {
    echo "  Not loading the schema. The schema can be found in sql_files/schema.sql.\n\n";
} 
