<?php

/**
 * Configuration File
 *
 * Contains the configuration options for this Ark Manager 
 *
 * License:
 *
 *
 * @author Robbie Hott
 * @license http://opensource.org/licenses/BSD-3-Clause BSD 3-Clause
 * @copyright 2015 the Rector and Visitors of the University of Virginia, and
 *            the Regents of the University of California
 */
namespace ark;

/**
 * Configuration class
 *
 * This class contains all the configuration variables for the entire system. It makes use of only
 * public static fields that may be read by any other class in the system. We use this to better scope
 * the configuration settings and avoid global variables and constants.
 *
 * @author Robbie Hott
 *
 */
class Config {
    
    /**
     * Full database connection information
     *
     * Connection information for the POSTGRES database
     *
     * @var array database connection information
     */
    public static $DATABASE = array (
        "database" => "ark_manager",
        "host" => "localhost",
        "port" => 5432,
        "user" => "ark_manager",
        "password" => "arkarkark"
    );

    /**
     * @var string Base URL for Arks
     */
    public static $ARK_URL = "http://snaccooperative.org";

    /**
     * @var string Temporary Institution Code for temporary Arks
     */
    public static $TEMPORARY_INSTITUTION_CODE = "99999";

}

